#ifndef __INTERPOLATION__
#define __INTERPOLATION__
/*
 *  interpolation.h
 *  owlcountry
 *
 *  Created by Mark Johns on 2/25/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#define M_PI 3.1415926

typedef enum EaseType {
	None = 0,
	EaseInQuad,
	EaseOutQuad,
	EaseInEaseOutQuad,		// 3
	EaseInCubic,
	EaseOutCubic,			
	EaseInEaseOutCubic,		// 6
	EaseInExpo,
	EaseOutExpo,
	EaseInEaseOutExpo,		// 9
	EaseInCirc,				
	EaseOutCirc,
	EaseInEaseOutCirc,		// 12
	EaseInSin,
	EaseOutSin,
	EaseInEaseOutSin,		// 15
	EaseInBounce,
	EaseOutBounce,
	EaseInEaseOutBounce,	// 18
	EaseInBack,
	EaseOutBack,			
	EaseInEaseOutBack,		// 21
	EaseInElastic,
	EaseOutElastic,
	EaseInEaseOutElastic,	// 24
	NumEaseTypes
} EaseType;

/* Interpolation Function for animation and events.
   send a float representing the time percentage between 0 and 1.0, and the function
   returns an interpolated value of type EaseType
*/

float interpolate(float time, EaseType easeType);

#endif /* __INTERPOLATION__ */